/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import net.adventurez.init.EntityInit;
import net.adventurez.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class IguanaEntity
extends Animal {
    public static final EntityDataAccessor<Boolean> OPEN_MOUTH = SynchedEntityData.m_135353_(IguanaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public IguanaEntity(EntityType<? extends IguanaEntity> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createIguanaAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.22);
    }

    public static boolean isValidNaturalSpawn(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_49993_) && world.m_45524_(pos, 0) > 8;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.8));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41866_}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new EatDeadBushGoal(this, 1.0));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OPEN_MOUTH, (Object)false);
    }

    protected SoundEvent m_7515_() {
        return SoundInit.IGUANA_IDLE_EVENT;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundInit.IGUANA_HURT_EVENT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.IGUANA_DEATH_EVENT;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundInit.IGUANA_STEP_EVENT, 0.35f, 1.0f);
    }

    public IguanaEntity createChild(ServerLevel serverWorld, AgeableMob passiveEntity) {
        return (IguanaEntity)EntityInit.IGUANA.m_20615_((Level)serverWorld);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_41866_);
    }

    private class EatDeadBushGoal
    extends MoveToBlockGoal {
        private final IguanaEntity iguanaEntity;

        public EatDeadBushGoal(IguanaEntity iguanaEntity2, double speed) {
            super((PathfinderMob)iguanaEntity2, speed, 12);
            this.iguanaEntity = iguanaEntity2;
        }

        public boolean m_8036_() {
            return !this.iguanaEntity.m_6162_() && !this.iguanaEntity.m_27593_() && super.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.iguanaEntity.f_19804_.m_135381_(OPEN_MOUTH, (Object)true);
        }

        public void m_8041_() {
            super.m_8041_();
            this.iguanaEntity.f_19804_.m_135381_(OPEN_MOUTH, (Object)false);
        }

        public void m_8037_() {
            if (!this.iguanaEntity.m_9236_().m_5776_() && this.m_25625_()) {
                if (this.iguanaEntity.m_21223_() < this.iguanaEntity.m_21233_()) {
                    this.iguanaEntity.m_5634_(2.0f);
                }
                this.iguanaEntity.m_9236_().m_46961_(this.f_25602_, false);
                this.iguanaEntity.m_27601_(600);
            }
            super.m_8037_();
        }

        public double m_8052_() {
            return 2.1;
        }

        protected int m_6099_(PathfinderMob mob) {
            return 60 + mob.m_217043_().m_188503_(600);
        }

        protected boolean m_6465_(LevelReader world, BlockPos pos) {
            return world.m_8055_(pos).m_60713_(Blocks.f_50036_);
        }
    }
}

